<?php
/**
 * Copyright © OXID eSales AG. All rights reserved.
 * See LICENSE file for license details.
 */

/*
 * @internal Do not make a module extension based on this file.
 * @see      https://oxidforge.org/en/core-oxid-eshop-classes-must-not-be-extended.html
 */
return [
    'OxidEsales\Eshop\Application\Component\BasketComponent'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\BasketComponent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\CategoriesComponent'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\CategoriesComponent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\CurrencyComponent'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\CurrencyComponent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\LanguageComponent'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\LanguageComponent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Locator'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Locator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\NewsComponent'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\NewsComponent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Component\ShopComponent'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\ShopComponent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\UserComponent'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\UserComponent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\UtilsComponent'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\UtilsComponent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\Actions'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\Actions::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\ArticleBox'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\ArticleBox::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\ArticleDetails'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\ArticleDetails::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\BetaNote'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\BetaNote::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\CategoryTree'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\CategoryTree::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\CookieNote'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\CookieNote::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\CurrencyList'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\CurrencyList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\Information'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\Information::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\LanguageList'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\LanguageList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\ManufacturerList'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\ManufacturerList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\MiniBasket'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\MiniBasket::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\Rating'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\Rating::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\Recommendation'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\Recommendation::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Component\Widget\Review'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\Review::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\ServiceList'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\ServiceList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\ServiceMenu'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\ServiceMenu::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\VendorList'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\VendorList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Component\Widget\WidgetController'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Component\Widget\WidgetController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountController'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountDownloadsController'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountDownloadsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountNewsletterController'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountNewsletterController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountNoticeListController'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountNoticeListController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountOrderController'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountOrderController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountPasswordController'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountPasswordController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountRecommlistController'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountRecommlistController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\AccountReviewController'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountReviewController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountUserController'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountUserController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\AccountWishlistController'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\AccountWishlistController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ActionsArticleAjax'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ActionsArticleAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ActionsController'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ActionsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ActionsGroupsAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ActionsGroupsAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ActionsList'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ActionsList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ActionsMain'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ActionsMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ActionsMainAjax'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ActionsMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ActionsOrderAjax'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ActionsOrderAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminContent'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminContent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminController'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminDetailsController'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminDetailsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminLinks'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminLinks::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminListController'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminListController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminNews'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminNews::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminNewsletter'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminNewsletter::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminOrder'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminOrder::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminPayment'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminPayment::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminPriceAlarm'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminPriceAlarm::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminStart'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminStart::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminUser'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminUser::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminWrapping'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminWrapping::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminlinksList'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminlinksList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AdminlinksMain'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AdminlinksMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleAccessoriesAjax'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleAccessoriesAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleAttribute'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleAttribute::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleAttributeAjax'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleAttributeAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleBundleAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleBundleAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleController'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleCrossselling'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleCrossselling::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleCrosssellingAjax'      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleCrosssellingAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleExtend'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleExtend::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleExtendAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleExtendAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleFiles'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleFiles::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleList'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleMain'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleOverview'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleOverview::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticlePictures'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticlePictures::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleReview'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleReview::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleSelectionAjax'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleSelectionAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleSeo'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleSeo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleStock'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleStock::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleUserdef'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleUserdef::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ArticleVariant'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ArticleVariant::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AttributeCategory'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AttributeCategory::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AttributeCategoryAjax'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AttributeCategoryAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AttributeController'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AttributeController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AttributeList'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AttributeList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AttributeMain'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AttributeMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AttributeMainAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AttributeMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\AttributeOrderAjax'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\AttributeOrderAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryController'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryList'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryMain'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryMainAjax'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryOrder'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryOrder::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryOrderAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryOrderAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryPictures'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryPictures::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategorySeo'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategorySeo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryText'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryText::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CategoryUpdate'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CategoryUpdate::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ContentList'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ContentList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ContentMain'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ContentMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ContentSeo'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ContentSeo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CountryController'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CountryController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CountryList'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CountryList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\CountryMain'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\CountryMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryArticles'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryArticles::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryArticlesAjax'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryArticlesAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryCategoriesAjax'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryCategoriesAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryController'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryGroupsAjax'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryGroupsAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryList'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryMain'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryMainAjax'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetController'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetCountryAjax'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetCountryAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetGroupsAjax'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetGroupsAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetList'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetMain'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetMainAjax'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetPayment'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetPayment::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetPaymentAjax'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetPaymentAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetRdfa'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetRdfa::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetUsers'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetUsers::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliverySetUsersAjax'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliverySetUsersAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryUsers'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryUsers::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DeliveryUsersAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DeliveryUsersAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiagnosticsController'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiagnosticsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiagnosticsList'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiagnosticsList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiagnosticsMain'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiagnosticsMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountArticles'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountArticles::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountArticlesAjax'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountArticlesAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountCategoriesAjax'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountCategoriesAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountController'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountGroupsAjax'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountGroupsAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountItemAjax'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountItemAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountList'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountMain'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountMainAjax'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountUsers'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountUsers::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DiscountUsersAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DiscountUsersAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DynEconda'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DynEconda::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DynamicExportBaseController'  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DynamicExportBaseController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DynamicInterface'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DynamicInterface::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DynamicScreenController'      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DynamicScreenController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DynamicScreenList'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DynamicScreenList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\DynamicScreenLocal'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\DynamicScreenLocal::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\GenericExport'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\GenericExport::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\GenericExportDo'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\GenericExportDo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\GenericExportMain'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\GenericExportMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\GenericImport'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\GenericImport::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\GenericImportMain'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\GenericImportMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\LanguageController'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\LanguageController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\LanguageList'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\LanguageList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\LanguageMain'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\LanguageMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ListComponentAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ListComponentAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ListReview'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ListReview::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ListUser'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ListUser::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\LoginController'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\LoginController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ManufacturerController'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ManufacturerController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ManufacturerList'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ManufacturerList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ManufacturerMain'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ManufacturerMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ManufacturerMainAjax'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ManufacturerMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ManufacturerSeo'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ManufacturerSeo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ModuleConfiguration'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ModuleConfiguration::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ModuleController'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ModuleController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ModuleList'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ModuleList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ModuleMain'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ModuleMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ModuleSortList'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ModuleSortList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NavigationController'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NavigationController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NavigationTree'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NavigationTree::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsList'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsMain'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsMainAjax'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsText'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsText::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsletterList'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsletterList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsletterMain'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsletterMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsletterPlain'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsletterPlain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsletterPreview'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsletterPreview::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsletterSelection'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsletterSelection::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsletterSelectionAjax'      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsletterSelectionAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\NewsletterSend'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\NewsletterSend::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ObjectSeo'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ObjectSeo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\OrderAddress'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\OrderAddress::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\OrderArticle'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\OrderArticle::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\OrderDownloads'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\OrderDownloads::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\OrderList'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\OrderList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\OrderMain'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\OrderMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\OrderOverview'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\OrderOverview::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\OrderRemark'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\OrderRemark::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PaymentCountry'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PaymentCountry::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PaymentCountryAjax'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PaymentCountryAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PaymentList'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PaymentList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PaymentMain'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PaymentMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PaymentMainAjax'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PaymentMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PaymentRdfa'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PaymentRdfa::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PriceAlarmList'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PriceAlarmList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PriceAlarmMail'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PriceAlarmMail::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PriceAlarmMain'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PriceAlarmMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\PriceAlarmSend'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\PriceAlarmSend::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SelectListController'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SelectListController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SelectListList'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SelectListList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SelectListMain'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SelectListMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SelectListMainAjax'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SelectListMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SelectListOrderAjax'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SelectListOrderAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopConfiguration'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopConfiguration::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopController'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopDefaultCategoryAjax'      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopDefaultCategoryAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopLicense'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopLicense::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopList'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopMain'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopPerformance'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopPerformance::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopRdfa'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopRdfa::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopSeo'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopSeo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ShopSystem'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ShopSystem::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SystemInfoController'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SystemInfoController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SystemRequirements'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SystemRequirements::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SystemRequirementsList'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SystemRequirementsList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\SystemRequirementsMain'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\SystemRequirementsMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ThemeConfiguration'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ThemeConfiguration::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ThemeController'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ThemeController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ThemeList'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ThemeList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ThemeMain'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ThemeMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ToolsController'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ToolsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ToolsList'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ToolsList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\ToolsMain'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\ToolsMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserAddress'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserAddress::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserArticle'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserArticle::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserExtend'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserExtend::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserGroupController'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserGroupController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserGroupList'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserGroupList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserGroupMain'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserGroupMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserGroupMainAjax'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserGroupMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserList'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserMain'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserMainAjax'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserOverview'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserOverview::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserPayment'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserPayment::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\UserRemark'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\UserRemark::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VendorController'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VendorController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VendorList'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VendorList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VendorMain'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VendorMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VendorMainAjax'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VendorMainAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VendorSeo'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VendorSeo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VoucherSerieController'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VoucherSerieController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VoucherSerieExport'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VoucherSerieExport::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VoucherSerieGenerate'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VoucherSerieGenerate::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VoucherSerieGroups'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VoucherSerieGroups::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VoucherSerieGroupsAjax'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VoucherSerieGroupsAjax::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VoucherSerieList'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VoucherSerieList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\VoucherSerieMain'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\VoucherSerieMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\WrappingList'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\WrappingList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\Admin\WrappingMain'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\Admin\WrappingMain::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ArticleDetailsController'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ArticleDetailsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ArticleListController'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ArticleListController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\BasketController'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\BasketController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ClearCookiesController'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ClearCookiesController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\CompareController'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\CompareController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ContactController'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ContactController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ContentController'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ContentController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\CreditsController'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\CreditsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\DownloadController'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\DownloadController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ExceptionErrorController'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ExceptionErrorController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ForgotPasswordController'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ForgotPasswordController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\FrontendController'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\FrontendController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\InviteController'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\InviteController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\LinksController'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\LinksController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ManufacturerListController'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ManufacturerListController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\MoreDetailsController'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\MoreDetailsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\NewsController'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\NewsController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\NewsletterController'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\NewsletterController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\OrderController'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\OrderController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\OxidStartController'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\OxidStartController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\PaymentController'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\PaymentController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\PriceAlarmController'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\PriceAlarmController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\RecommListController'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\RecommListController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\RecommendationAddController'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\RecommendationAddController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\RegisterController'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\RegisterController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ReviewController'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ReviewController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\RssController'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\RssController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\SearchController'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\SearchController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\StartController'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\StartController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\SuggestController'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\SuggestController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Controller\TemplateController'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\TemplateController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\TextEditorHandler'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\TextEditorHandler::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\ThankYouController'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\ThankYouController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\UserController'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\UserController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\VendorListController'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\VendorListController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\WishListController'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\WishListController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Controller\WrappingController'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Controller\WrappingController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\ActionList'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\ActionList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Actions'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Actions::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Address'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Address::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\AmountPriceList'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\AmountPriceList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Article'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Article::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\ArticleList'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\ArticleList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Attribute'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Attribute::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\AttributeList'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\AttributeList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Basket'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Basket::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\BasketContentMarkGenerator'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\BasketContentMarkGenerator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\BasketItem'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\BasketItem::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\BasketReservation'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\BasketReservation::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Category'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Category::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\CategoryList'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\CategoryList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\CompanyVatIn'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\CompanyVatIn::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Content'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Content::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\ContentList'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\ContentList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Contract\ArticleInterface'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Contract\ArticleInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Contract\CacheConnectorInterface'        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Contract\CacheConnectorInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Country'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Country::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\CountryList'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\CountryList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Delivery'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Delivery::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\DeliveryList'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\DeliveryList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\DeliverySet'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\DeliverySet::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\DeliverySetList'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\DeliverySetList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Diagnostics'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Diagnostics::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\DiagnosticsOutput'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\DiagnosticsOutput::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Discount'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Discount::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\DiscountList'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\DiscountList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\File'                                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\File::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\FileChecker'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\FileChecker::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Model\FileCheckerResult'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\FileCheckerResult::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Model\FileCollector'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\FileCollector::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Groups'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Groups::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Links'                                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Links::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\ListObject'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\ListObject::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Maintenance'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Maintenance::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Manufacturer'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Manufacturer::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\ManufacturerList'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\ManufacturerList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\MdVariant'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\MdVariant::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\MediaUrl'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\MediaUrl::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\News'                                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\News::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\NewsList'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\NewsList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\NewsSubscribed'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\NewsSubscribed::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Newsletter'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Newsletter::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Object2Category'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Object2Category::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Object2Group'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Object2Group::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Order'                                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Order::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\OrderArticle'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\OrderArticle::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\OrderArticleList'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\OrderArticleList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\OrderFile'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\OrderFile::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\OrderFileList'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\OrderFileList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Payment'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Payment::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\PaymentGateway'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\PaymentGateway::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\PaymentList'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\PaymentList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\PriceAlarm'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\PriceAlarm::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Rating'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Rating::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\RecommendationList'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\RecommendationList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Remark'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Remark::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\RequiredAddressFields'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\RequiredAddressFields::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\RequiredFieldValidator'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\RequiredFieldValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\RequiredFieldsValidator'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\RequiredFieldsValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Review'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Review::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\RssFeed'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\RssFeed::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Search'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Search::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SelectList'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SelectList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Selection'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Selection::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SeoEncoderArticle'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SeoEncoderArticle::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SeoEncoderCategory'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SeoEncoderCategory::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SeoEncoderContent'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SeoEncoderContent::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SeoEncoderManufacturer'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SeoEncoderManufacturer::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SeoEncoderRecomm'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SeoEncoderRecomm::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Application\Model\SeoEncoderVendor'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SeoEncoderVendor::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Shop'                                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Shop::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\ShopList'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\ShopList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\ShopViewValidator'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\ShopViewValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SimpleVariant'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SimpleVariant::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SimpleVariantList'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SimpleVariantList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\SmartyRenderer'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\SmartyRenderer::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\State'                                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\State::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\User'                                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\User::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\UserAddressList'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\UserAddressList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\UserBasket'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\UserBasket::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\UserBasketItem'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\UserBasketItem::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\UserList'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\UserList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\UserPayment'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\UserPayment::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\User\UserShippingAddressUpdatableFields' => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\User\UserShippingAddressUpdatableFields::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\User\UserUpdatableFields'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\User\UserUpdatableFields::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\VariantHandler'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\VariantHandler::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\VariantSelectList'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\VariantSelectList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\VatSelector'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\VatSelector::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Vendor'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Vendor::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\VendorList'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\VendorList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Voucher'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Voucher::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\VoucherList'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\VoucherList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\VoucherSerie'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\VoucherSerie::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Application\Model\Wrapping'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Application\Model\Wrapping::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\AdminLogSqlDecorator'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\AdminLogSqlDecorator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\DataObject\ApplicationServer'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\DataObject\ApplicationServer::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Dao\ApplicationServerDao'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Dao\ApplicationServerDao::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Dao\BaseDaoInterface'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Dao\BaseDaoInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Dao\ApplicationServerDaoInterface'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Dao\ApplicationServerDaoInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Service\ApplicationServerExporter'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Service\ApplicationServerExporter::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Service\ApplicationServerExporterInterface'           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Service\ApplicationServerExporterInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Service\ApplicationServerService'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Service\ApplicationServerService::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Service\ApplicationServerServiceInterface'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Service\ApplicationServerServiceInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Autoload\BackwardsCompatibilityAutoload'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Autoload\BackwardsCompatibilityAutoload::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\BackwardsCompatibleClassNameProvider'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\BackwardsCompatibleClassNameProvider::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Base'                                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Base::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\CompanyVatInChecker'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\CompanyVatInChecker::class,
        'isAbstract'       => true,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\CompanyVatInCountryChecker'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\CompanyVatInCountryChecker::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\CompanyVatInValidator'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\CompanyVatInValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Config'                                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Config::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ConfigFile'                                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ConfigFile::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\AbstractUpdatableFields'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\AbstractUpdatableFields::class,
        'isAbstract'       => true,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\ClassNameResolverInterface'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\ClassNameResolverInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\ClassProviderStorageInterface'               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\ClassProviderStorageInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\ControllerMapProviderInterface'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\ControllerMapProviderInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\IConfigurable'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\IConfigurable::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\ICountryAware'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\ICountryAware::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\IDisplayError'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\IDisplayError::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\IModuleValidator'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\IModuleValidator::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\ISelectList'                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\ISelectList::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Contract\IUrl'                                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Contract\IUrl::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Controller\BaseController'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Controller\BaseController::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Counter'                                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Counter::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\CreditCardValidator'                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\CreditCardValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Curl'                                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Curl::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\DatabaseProvider'                                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\DatabaseProvider::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Database\Adapter\DatabaseInterface'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Database\Adapter\DatabaseInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Database\Adapter\Doctrine\Database'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Database\Adapter\Doctrine\Database::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Database\Adapter\Doctrine\ResultSet'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Database\Adapter\Doctrine\ResultSet::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Database\Adapter\ResultSetInterface'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Database\Adapter\ResultSetInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\DbMetaDataHandler'                                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\DbMetaDataHandler::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\DebugInfo'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\DebugInfo::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Decryptor'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Decryptor::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\DisplayError'                                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\DisplayError::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\DynamicImageGenerator'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\DynamicImageGenerator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Edition\EditionPathProvider'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Edition\EditionPathProvider::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Core\Edition\EditionRootPathProvider'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Edition\EditionRootPathProvider::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Core\Edition\EditionSelector'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Edition\EditionSelector::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Core\Email'                                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Email::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\EmailBuilder'                                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\EmailBuilder::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Encryptor'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Encryptor::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\ArticleException'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\ArticleException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\ArticleInputException'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\ArticleInputException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\ConnectionException'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\ConnectionException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\CookieException'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\CookieException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\DatabaseConnectionException'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\DatabaseConnectionException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\DatabaseErrorException'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\DatabaseErrorException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\DatabaseException'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\DatabaseException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\DatabaseNotConfiguredException'             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\DatabaseNotConfiguredException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\ExceptionHandler'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\ExceptionHandler::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\ExceptionToDisplay'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\ExceptionToDisplay::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\FileException'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\FileException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\InputException'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\InputException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\LanguageException'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\LanguageException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Core\Exception\ModuleValidationException'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\ModuleValidationException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\NoArticleException'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\NoArticleException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\ObjectException'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\ObjectException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\OutOfStockException'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\OutOfStockException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\RoutingException'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\RoutingException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\ShopException'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\ShopException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\StandardException'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\StandardException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\SystemComponentException'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\SystemComponentException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\UserException'                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\UserException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\VoucherException'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\VoucherException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Exception\NoResultException'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Exception\NoResultException::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Field'                                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Field::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\FileCache'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\FileCache::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\FileSystem\FileSystem'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\FileSystem\FileSystem::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Form\FormFields'                                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Form\FormFields::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Form\FormFieldsCleaner'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Form\FormFieldsCleaner::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Form\FormFieldsTrimmerInterface'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Form\FormFieldsTrimmerInterface::class,
        'isAbstract'       => false,
        'isInterface'      => true,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Form\FormFieldsTrimmer'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Form\FormFieldsTrimmer::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Form\UpdatableFieldsConstructor'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Form\UpdatableFieldsConstructor::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\GenericImport'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\GenericImport::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\Accessories2Article'       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\Accessories2Article::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\Article'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\Article::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\Article2Action'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\Article2Action::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\Article2Category'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\Article2Category::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\ArticleExtends'            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\ArticleExtends::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\Category'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\Category::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\Country'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\Country::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\CrossSelling'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\CrossSelling::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\ImportObject'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\ImportObject::class,
        'isAbstract'       => true,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\Order'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\Order::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\OrderArticle'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\OrderArticle::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\ScalePrice'                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\ScalePrice::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\User'                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\User::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\GenericImport\ImportObject\Vendor'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\GenericImport\ImportObject\Vendor::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Hasher'                                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Hasher::class,
        'isAbstract'       => true,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Header'                                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Header::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\InputValidator'                                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\InputValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Language'                                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Language::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\MailValidator'                                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\MailValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Model\BaseModel'                                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Model\BaseModel::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Model\FieldNameHelper'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Model\FieldNameHelper::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Model\ListModel'                                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Model\ListModel::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Model\MultiLanguageModel'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Model\MultiLanguageModel::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\Module'                                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\Module::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleCache'                                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleCache::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleChainsGenerator'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleChainsGenerator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleExtensionsCleaner'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleExtensionsCleaner::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleInstaller'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleInstaller::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleList'                                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleMetadataValidator'                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleMetadataValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleTemplateBlockContentReader'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleTemplateBlockContentReader::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleTemplateBlockPathFormatter'              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleTemplateBlockPathFormatter::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleTemplateBlockRepository'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleTemplateBlockRepository::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleTemplatePathCalculator'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleTemplatePathCalculator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleTranslationPathFinder'                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleTranslationPathFinder::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleValidatorFactory'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleValidatorFactory::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleVariablesLocator'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleVariablesLocator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\NamespaceInformationProvider'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\NamespaceInformationProvider::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\NoJsValidator'                                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\NoJsValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineCaller'                                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineCaller::class,
        'isAbstract'       => true,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineLicenseCheck'                                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineLicenseCheck::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineLicenseCheckCaller'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineLicenseCheckCaller::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineLicenseCheckRequest'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineLicenseCheckRequest::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineLicenseCheckResponse'                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineLicenseCheckResponse::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineModuleVersionNotifier'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineModuleVersionNotifier::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineModuleVersionNotifierCaller'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineModuleVersionNotifierCaller::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineModulesNotifierRequest'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineModulesNotifierRequest::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineRequest'                                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineRequest::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineServerEmailBuilder'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineServerEmailBuilder::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OnlineVatIdCheck'                                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OnlineVatIdCheck::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\OpenSSLFunctionalityChecker'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\OpenSSLFunctionalityChecker::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Output'                                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Output::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Oxid'                                                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Oxid::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\PasswordHasher'                                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\PasswordHasher::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\PasswordSaltGenerator'                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\PasswordSaltGenerator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\PictureHandler'                                       => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\PictureHandler::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Price'                                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Price::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\PriceList'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\PriceList::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Registry'                                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Registry::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Request'                                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Request::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Routing\ControllerClassNameResolver'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Routing\ControllerClassNameResolver::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Routing\ModuleControllerMapProvider'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Routing\ModuleControllerMapProvider::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Routing\Module\ClassProviderStorage'                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Routing\Module\ClassProviderStorage::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Routing\ShopControllerMapProvider'                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Routing\ShopControllerMapProvider::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SeoDecoder'                                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SeoDecoder::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SeoEncoder'                                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SeoEncoder::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SepaBICValidator'                                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SepaBICValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SepaIBANValidator'                                    => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SepaIBANValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SepaValidator'                                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SepaValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Session'                                              => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Session::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SettingsHandler'                                      => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SettingsHandler::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Sha512Hasher'                                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Sha512Hasher::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ShopControl'                                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ShopControl::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ShopIdCalculator'                                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ShopIdCalculator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ShopVersion'                                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ShopVersion::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SimpleXml'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SimpleXml::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Smarty\Plugin\Emos'                                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Smarty\Plugin\Emos::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Smarty\Plugin\EmosAdapter'                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Smarty\Plugin\EmosAdapter::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Smarty\Plugin\EmosItem'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Smarty\Plugin\EmosItem::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Str'                                                  => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Str::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\StrMb'                                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\StrMb::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\StrRegular'                                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\StrRegular::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SubShopSpecificFileCache'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SubShopSpecificFileCache::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SystemEventHandler'                                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SystemEventHandler::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\SystemRequirements'                                   => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\SystemRequirements::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\TableViewNameGenerator'                               => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\TableViewNameGenerator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Theme'                                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Theme::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UniversallyUniqueIdGenerator'                         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UniversallyUniqueIdGenerator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UserCounter'                                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UserCounter::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Utils'                                                => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Utils::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsCount'                                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsCount::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsDate'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsDate::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsFile'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsFile::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsObject'                                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsObject::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsPic'                                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsPic::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsServer'                                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsServer::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsString'                                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsString::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsUrl'                                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsUrl::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsView'                                            => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsView::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\UtilsXml'                                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\UtilsXml::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ViewConfig'                                           => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ViewConfig::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ViewHelper\JavaScriptRegistrator'                     => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ViewHelper\JavaScriptRegistrator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ViewHelper\JavaScriptRenderer'                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ViewHelper\JavaScriptRenderer::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ViewHelper\StyleRegistrator'                          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ViewHelper\StyleRegistrator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\ViewHelper\StyleRenderer'                             => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\ViewHelper\StyleRenderer::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\WidgetControl'                                        => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\WidgetControl::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => false
    ],
    'OxidEsales\Eshop\Core\Module\ModuleSmartyPluginDirectories'                 => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleSmartyPluginDirectories::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Core\Module\ModuleSmartyPluginDirectoryRepository'         => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleSmartyPluginDirectoryRepository::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
    'OxidEsales\Eshop\Core\Module\ModuleSmartyPluginDirectoryValidator'          => [
        'editionClassName' => \OxidEsales\EshopCommunity\Core\Module\ModuleSmartyPluginDirectoryValidator::class,
        'isAbstract'       => false,
        'isInterface'      => false,
        'isDeprecated'     => true
    ],
];
