/**
 * This file is part of OXID eSales Wave theme.
 *
 * OXID eSales Wave theme is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OXID eSales Wave theme is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OXID eSales Wave theme.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @link      http://www.oxid-esales.com
 * @copyright (C) OXID eSales AG 2003-2016
 */
$( document ).ready( function()
    {
        var $oReviewRating = $( '#reviewRating' );

        if( $oReviewRating.length )
        {
            var $oRatingForm = $( '#rating' );

            $oReviewRating.find( '.ox-write-review' ).on( 'click mouseenter touch', function()
                {
                    var $this    = $( this ),
                        $oParent = $this.parent();

                    $oParent.prevAll().find( 'i' ).removeClass( 'far' ).addClass( 'fas' );
                    $oParent.nextAll().find( 'i' ).removeClass( 'fas' ).addClass( 'far' );
                    $this.find( 'i' ).removeClass( 'far' ).addClass( 'fas' );

                    $oRatingForm.find( '#recommListRating, #productRating' ).val( $oParent.attr( 'data-rate-value' ) );
                }
            );
        }
    }
);